// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gui/imagebutton.h>
#include <gui/stringview.h>
#include <gui/layoutview.h>
#include "common.h"
#include "sidebar_title.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// 
//
///////////////////////////////////////////////////////////////////////////////

class SideBarStringView : public StringView
{
public:
	SideBarStringView( const String title ) : StringView( Rect(), title, title )	
	{	
	}

	void Paint( const os::Rect& cUpdateRect )
	{
		// Erase background noise
		FillRect( cUpdateRect, get_default_color( COL_NORMAL ) );

		// Draw nice title
		SetFgColor( get_default_color( COL_MENU_TEXT ) );
		Point text_size = GetTextExtent( GetString() );
		DrawString( Point( 12.0f, text_size.y), GetString() );
	
		// Draw same nice lines
		DrawFrame( Rect( 4.0f, 2.0f + text_size.y / 2.0f, 8.0f, 3.0f + text_size.y / 2.0f ), FRAME_THIN );
		DrawFrame( Rect( 4.0f, 6.0f + text_size.y / 2.0f, 8.0f, 7.0f + text_size.y / 2.0f ), FRAME_THIN );

		if( 18.0f + text_size.x < GetBounds().right )
		{
			DrawFrame( Rect( 18.0f + text_size.x, 2.0f + text_size.y / 2.0f, GetBounds().right, 3.0f + text_size.y / 2.0f ), FRAME_THIN );
			DrawFrame( Rect( 18.0f + text_size.x, 6.0f + text_size.y / 2.0f, GetBounds().right, 7.0f + text_size.y / 2.0f ), FRAME_THIN );
		}
	}

private:
};

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class SideBarTitle :: _Private
{
public:
	_Private() {};

	ImageButton* m_CloseButton;
	SideBarStringView* m_Title;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////

SideBarTitle :: SideBarTitle( const String title, Message* msg ) : View( Rect(), title )
{
	// Create the private class
	m = new _Private();

	
	// Create widgets
	LayoutNode*	root_node = new HLayoutNode( "pcRootNode" );
	LayoutView*	root_view = new LayoutView( GetBounds(), "pcRootView" );
	root_view->SetRoot( root_node );
	AddChild( root_view );
	
	m->m_Title = new SideBarStringView( title );

	BitmapImage* close_icon = LoadImage( "close_button.png" );
	m->m_CloseButton = new ImageButton( Rect(), "close_button", "", msg, close_icon );

	root_node->AddChild( m->m_Title, 1.0f );
	root_node->AddChild( m->m_CloseButton, 0.0f );
}

SideBarTitle :: ~SideBarTitle()
{
	delete m;
}

Point SideBarTitle :: GetPreferredSize( bool bLargest ) const
{
	if( bLargest )
		return Point( 1000, 1000 );

	return Point( 100, 20 );
}
