// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gui/layoutview.h>
#include <gui/frameview.h>
#include <gui/stringview.h>
#include "sidebar_info.h"
#include "messages.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class SideBarInfo :: _Private
{
public:
	_Private() {};

	FrameView* m_Preview;

	FrameView* m_Properties;
	StringView* m_Name;
	StringView* m_NameEntry;
	StringView* m_Mime;
	StringView* m_MimeEntry;
	StringView* m_Size;
	StringView* m_SizeEntry;
	StringView* m_Modified;
	StringView* m_ModifiedEntry;

	FrameView* m_Attributes;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
SideBarInfo :: SideBarInfo( Message* hide_msg, Message* msg ) : SideBar( "Information", hide_msg )
{
	// Create the private class
	m = new _Private();


//	m->m_Preview = new FrameView( Rect(), "Preview", "Preview" );
//	SideBar::GetRoot()->AddChild( m->m_Preview, 1.0f );

// Create the properties frame
	m->m_Properties = new FrameView( Rect(), "Properties", "Properties" );
	SideBar::GetRoot()->AddChild( m->m_Properties, 1.0f );

	// Create the layout
	LayoutView* view_prop = new LayoutView( GetBounds(), "view_prop" );
	m->m_Properties->AddChild( view_prop );
	VLayoutNode* view_root = new VLayoutNode( "v_root" );
	view_root->SetBorders( Rect( 10, 5, 10, 5 ) );
	view_prop->SetRoot( view_root );

	// Name
	HLayoutNode* HName = new HLayoutNode( "h_name" );

	m->m_Name = new StringView( Rect(), "name_label", "Name:" );	
	m->m_NameEntry = new StringView( Rect(), "name_label", "12345" );	

	HName->AddChild( m->m_Name, 0.0f );
	HName->AddChild( new HLayoutSpacer( "", 5.0f, 5.0f ) );
	HName->AddChild( m->m_NameEntry );

	view_root->AddChild( HName );

//	m->m_Attributes = new FrameView( Rect(), "Attributes", "Attributes" );
//	SideBar::GetRoot()->AddChild( m->m_Attributes, 0.0f );

view_prop->InvalidateLayout();
}

SideBarInfo :: ~SideBarInfo()
{
	delete m;
}


