/*  libsyllable.so - the highlevel API library for Syllable
 *  Copyright (C) 1999 - 2001 Kurt Skauen
 *  Copyright (C) 2003 The Syllable Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of version 2 of the GNU Library
 *  General Public License as published by the Free Software
 *  Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 *  MA 02111-1307, USA
 */

#ifndef __FILEVIEW_H__
#define __FILEVIEW_H__

#include <sys/stat.h>
#include <gui/control.h>
#include "iconview.h"
#include <storage/path.h>
#include <util/string.h>
#include <storage/nodemonitor.h>

#include <vector>
#include <string>
#include <stack>

namespace os_priv
{
    class DirKeeper;
}

class os::Message;
class os::Bitmap;
class os::Image;
class os::Menu;

class DirectoryIconData : public os::IconData
{
public:
	DirectoryIconData()
	{
		m_pcMonitor = NULL;
		m_bImageUpdateRequired = false;
	}
	~DirectoryIconData();

	os::String m_zPath;
	struct stat m_sStat;
	bool m_bBrokenLink;
	os::NodeMonitor* m_pcMonitor;
	bool m_bImageUpdateRequired;
private:
	DirectoryIconData& operator=( const DirectoryIconData& );
	DirectoryIconData( const DirectoryIconData& );
};


/** Directory view suitable for file-requesters and other file browsers.
 * \ingroup gui
 * \par Description:
 *
 * \sa os::FileRequester
 * \author	Arno Klenke (arno_klenke@yahoo.de)
 *****************************************************************************/

class FileView : public os::IconView
{
public:
    FileView( const os::String& cPath );
    ~FileView();
  
    void ReRead();
    void SetPath( const os::String& cPath );
    os::String GetPath() const;
    os::Image* GetDirIcon() const;
    bool	JobsPending() const;

    void	SetDirChangeMsg( os::Message* pcMsg );
	void	SetDirectoryLocked( bool bLocked );
	void	SetReReadReadyMsg( os::Message* pcMessage );
	void	SetOpenTabMsg( os::Message* pcMessage );
	void	SetAutoLaunch( bool bAutoLaunch );
	void 	SetPreviewMode( bool bPreview );
	bool 	GetPreviewMode();	

	void 	SetRememberMode( bool bRemember );
	bool 	GetRememberMode();	

    virtual void  DirChanged( const os::String& cNewPath );
    virtual void  Invoked( uint nIcon, os::IconData *pcData );
    virtual void  DragSelection( os::Point cStartPoint );
    virtual void  OpenContextMenu( os::Point cPosition, bool bMouseOverIcon );
    virtual void  HandleMessage( os::Message* pcMessage );
    virtual void  AttachedToWindow();
    virtual void  DetachedFromWindow();
    virtual void  MouseUp( const os::Point& cPosition, uint32 nButtons, os::Message* pcData );
	virtual void  MouseMove( const os::Point& cNewPos, int nCode, uint32 nButtons, os::Message* pcData );
    virtual void  KeyDown( const char* pzString, const char* pzRawString, uint32 nQualifiers );
	virtual void RenameIconRequested( uint nIcon, os::String new_name );

private:
	enum { M_ADD_ENTRY, M_UPDATE_ENTRY, M_REMOVE_ENTRY, M_LAYOUT, M_THUMBNAIL_LAYOUT, M_REREAD, M_MOUNT = 100, M_UNMOUNT, 
    		M_NEW_DIR, M_DELETE, M_RENAME, M_OPEN_WITH, M_INFO, M_MOVE_TO_TRASH, M_EMPTY_TRASH, M_JOB_END, M_JOB_END_REREAD, M_READY,
			M_CUT, M_COPY, M_PASTE, M_OPEN_TAB, M_OPEN, M_OPEN_IN_TERMINAL, M_VIEW_AS_ICONS, M_VIEW_AS_LIST, M_VIEW_AS_DETAILS, M_VIEW_AS_REMEMBER, M_VIEW_AS_PREVIEW };

    FileView& operator=( const FileView& );
    FileView( const FileView& );

    friend class os_priv::DirKeeper;
    class _Private;
    _Private* m;
    
};


#endif



