// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gui/layoutview.h>
#include <gui/button.h>
#include <gui/imageview.h>
#include <gui/image.h>
#include <gui/stringview.h>
#include "about.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class About :: _Private
{
public:
	_Private() {};

	void _Close( Window* window )
	{
		// Close the About window
		window->Hide();
	}

	enum AboutMessage { MSG_CLOSE };

	// Layouts
	LayoutView* pcLayoutView;
	LayoutNode* pcRoot;

	// Widgets
	Image* pcAboutImage;
	ImageView* pcAboutImageView;

	StringView* pcVersionLabel;
	StringView* pcTextEditorLabel;

	Button* pcCloseButton;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
About :: About() : Window( Rect(), "about_ocadis", "About EFileBrowser", WND_NO_ZOOM_BUT | WND_NO_DEPTH_BUT | WND_NOT_RESIZABLE )
{
	// Create the private class
	m = new _Private();

	// Create layout
	m->pcLayoutView = new LayoutView( Rect(), "" );
	AddChild( m->pcLayoutView );

	// Create basepanel	
	m->pcRoot = new VLayoutNode( "" );
	m->pcRoot->SetVAlignment( os::ALIGN_CENTER );
	m->pcRoot->SetHAlignment( os::ALIGN_CENTER );
	m->pcLayoutView->SetRoot( m->pcRoot );

	// Create the oCADis image
	m->pcAboutImageView = new ImageView( Rect(), "about_image", LoadImage( "about.png" ) );
	m->pcRoot->AddChild( m->pcAboutImageView );

	m->pcRoot->AddChild( new VLayoutSpacer( "", 8, 8 ) );

	// Create version label
	m->pcVersionLabel = new StringView( Rect(), "version_label", "Version: 0.0.1", ALIGN_RIGHT );
	m->pcRoot->AddChild( m->pcVersionLabel );
	Font* f = m->pcVersionLabel->GetFont();
	f->SetSize( 8 );
	m->pcVersionLabel->SetFont( f );

	m->pcRoot->AddChild( new VLayoutSpacer( "", 6, 6 ) );

	// Create syllable label
	m->pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "The Extended FileBrowser for Syllable", ALIGN_CENTER );
	m->pcRoot->AddChild( m->pcTextEditorLabel );

	m->pcRoot->AddChild( new VLayoutSpacer( "", 4, 4 ) );

	m->pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "(c)2007 Jonas Jarvoll - Released under GPL", ALIGN_CENTER );
	m->pcRoot->AddChild( m->pcTextEditorLabel );

	m->pcRoot->AddChild( new VLayoutSpacer( "", 4, 4 ) );

	m->pcTextEditorLabel = new StringView( Rect(), "texteditor_label", "http://www.jarvoll.se/syllable", ALIGN_CENTER );
	m->pcRoot->AddChild( m->pcTextEditorLabel );

	m->pcRoot->AddChild( new VLayoutSpacer( "", 8, 8 ) );

	// Create close button
	m->pcCloseButton = new Button( Rect(), "close_button", "Close", new Message( _Private::MSG_CLOSE ) );
	m->pcCloseButton->SetTarget( this );
	m->pcRoot->AddChild( m->pcCloseButton );
	SetDefaultButton( m->pcCloseButton );
	
	// Set size of window
	Point size = m->pcLayoutView->GetPreferredSize( false );
	ResizeTo( size.x + 20, size.y + 20 );
	CenterInScreen();

	// Close dialog with escape
	ShortcutKey s( VK_ESCAPE ); 
	AddShortcut( s, new Message( _Private::MSG_CLOSE ) );
}

About :: ~About()
{
	delete m;
}

void About :: HandleMessage(Message* pcMessage)
{
	if( pcMessage->GetCode() == _Private::MSG_CLOSE )
		m->_Close( this );
	else
		Window::HandleMessage( pcMessage );
}

bool About :: OkToQuit()
{
	m->_Close( this );
	return false;
}

void About :: Raise()
{
	if( IsVisible() )
		Show( false );

	Show( true );

	MakeFocus();
}

void About :: FrameSized( const Point& cDelta )
{
	Window::FrameSized( cDelta );

	Rect cFrame = GetBounds();
	cFrame.Resize( 2, 2, -2, -2 );
	m->pcLayoutView->SetFrame( cFrame );	
}

