// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gui/layoutview.h>
#include "sidebar.h"
#include "sidebar_title.h"
#include "messages.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class SideBar :: _Private
{
public:
	_Private() {};

	SideBarTitle* m_Title;
	LayoutNode* m_RootNode;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
SideBar :: SideBar( const String title, Message* hide_msg ) : View( Rect(), title )
{
	// Create the private class
	m = new _Private();

	// Create widgets
	m->m_RootNode = new VLayoutNode( "pcRootNode" );
	LayoutView*	root_view = new LayoutView( GetBounds(), "pcRootView" );
	root_view->SetRoot( m->m_RootNode );
	AddChild( root_view );

	// Create title
	m->m_Title = new SideBarTitle( title, hide_msg );
	m->m_RootNode->AddChild( m->m_Title, 0.0f );
}

SideBar :: ~SideBar()
{
	delete m;
}

LayoutNode* SideBar :: GetRoot()
{
	return m->m_RootNode;
}


