// EFileBrowser	 (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __FOLDERTREEVIEW_H__
#define __FOLDERTREEVIEW_H__

#include <vector>

#include "etreeview.h"
#include <gui/rect.h>
#include <gui/image.h>
#include <util/string.h>
#include <util/message.h>
#include <util/string.h>
#include <util/invoker.h>
#include <storage/memfile.h>

class FolderTreeView : public os::ETreeView
{
public:
	FolderTreeView( const os::Rect& cFrame, const os::String& cPath, uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP );
	~FolderTreeView();

	void SetDirChangeMsg( os::Message * pcMsg );
    void SetPath( const os::String& cPath );

	virtual void HandleMessage( os::Message* pcMessage );
//	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void AllAttached();
	
	status_t SetTarget( const os::Handler* pcHandler, const os::Looper* pcLooper = NULL );
	status_t SetTarget( const os::Messenger& cMessenger );

protected:
	enum { MSG_EXPAND, MSG_SELECT };

	enum { M_ADD_ENTRY, M_UPDATE_ENTRY, M_REMOVE_ENTRY, M_LAYOUT, M_REREAD, M_MOUNT = 100, M_UNMOUNT, M_NEW_DIR, M_DELETE, M_RENAME, M_OPEN_WITH, M_INFO, M_MOVE_TO_TRASH, M_EMPTY_TRASH, M_JOB_END, M_JOB_END_REREAD };

private:
	void ChangePath( os::String path );
	void ReadRoot();
	bool FindSubDir( os::String path );
	void DisplayPath( int row, os::ETreeViewNode* parent, os::String path );
	void ExpandItem( int row, os::ETreeViewNode* parent );
	void CollapseItem( int row, os::ETreeViewNode* parent );
	void SplitPath( const os::String& cPath, std::vector<os::String>& vec );

    class Private;
    Private* m;
};

#endif

