// EFileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __THUMBSDB_H__
#define __THUMBSDB_H__

#include <util/string.h>
#include <gui/image.h>
#include <util/locker.h>

class Thumbnail
{
public:
	enum ThumbnailStatus { NO_IMAGE, PROCESSING, READY };

	Thumbnail( os::String path );
	~Thumbnail();

	enum ThumbnailStatus GetStatus();
	void SetStatus( enum ThumbnailStatus status );

	os::String GetPath();

	os::Image* GetDuplicatedImage();

	void SetImage( os::Image* img );

private:
	class _Private;
	_Private* m;
};

class ThumbsDB : public os::Locker
{
public:
	ThumbsDB();
	~ThumbsDB();

	os::Image* GetThumbnail( os::String path, bool& update );
	os::Image* GetUpdatedThumbnail( os::String path );
	Thumbnail* CreateThumbnail( os::String path );

	static ThumbsDB* Get();

private:
	static ThumbsDB* m_Instance;

	class _Private;
	_Private* m;
};

#endif
