// EfileBrowser (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "main.h"
#include "appwindow.h"

using namespace os;

int main( int argc, char* argv[] )
{
	const char *pzHome = getenv( "HOME" );
	EFileBrowserApp* pcApp = NULL;
	struct stat sStat;
	
	if ( ( argc > 1 ) && ( lstat( argv[1], &sStat ) >= 0 ) )
		pcApp = new EFileBrowserApp( argv[1] );
	else
		pcApp = new EFileBrowserApp( pzHome );

	pcApp->Run();

	return( 0 );
}

AppWindow* EFileBrowserApp :: m_AppWindow = NULL;

EFileBrowserApp :: EFileBrowserApp( os::String path ) : Application( "application/x-EFileBrowser" )
{
	m_AppWindow = new AppWindow( path, Rect( 100, 100, 900, 700 ) );
	m_AppWindow->Show();
	m_AppWindow->MakeFocus();
}



