/*  libsyllable.so - the highlevel API library for Syllable
 *  Copyright (C) 1999 - 2001 Kurt Skauen
 *  Copyright (C) 2003 The Syllable Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of version 2 of the GNU Library
 *  General Public License as published by the Free Software
 *  Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 *  MA 02111-1307, USA
 */

#ifndef __DIRKEEPER_H__
#define __DIRKEEPER_H__

#include <util/looper.h>
#include <util/message.h>
#include <util/messenger.h>
#include <util/string.h>
#include <storage/nodemonitor.h>
#include <storage/directory.h>
#include "thumbcreator.h"

namespace os_priv
{

	
	class DirKeeper:public os::Looper
	{
	    public:
		enum
		{ M_CHANGE_DIR = 1, M_PREVIEW, M_COPY_FILES, M_MOVE_FILES, M_DELETE_FILES, M_RENAME_FILES, M_ENTRIES_ADDED, M_ENTRIES_REMOVED, M_ENTRIES_UPDATED, M_LAYOUT_UPDATED, M_THUMBNAIL_LAYOUT_UPDATED, M_THUMBNAIL_READY, M_THUMBNAIL_LAYOUT };
		  DirKeeper( const os::Messenger & cTarget, const os::String& cPath );
		virtual void HandleMessage( os::Message * pcMessage );
		virtual bool Idle();
		bool OkToQuit();
		void Stop();
		status_t GetNode( os::String zPath, os::FSNode* pcNode, bool *pbBrokenLink );
		os::Directory* GetCurrentDir() { return( m_pcCurrentDir ); }
		bool IsReading() { return( m_eState == S_READDIR ); }
   private:
		
		void SendAddMsg( const os::String& cName, dev_t nDevice, ino_t nInode );
		void SendRemoveMsg( const os::String& cName, dev_t nDevice, ino_t nInode );
		void SendUpdateMsg( const os::String& cName, dev_t nDevice, ino_t nInode, bool bReloadIcon );
		void SendDriveAddMsg( const os::String& cName, const os::String& cPath );
		void SendReadyMsg();

		enum state_t
		{ S_IDLE, S_READDIR };
		bool m_bRunning;
		os::Messenger m_cTarget;
		os::String m_cPath;
		os::Directory *m_pcCurrentDir;
		os::NodeMonitor m_cMonitor;
		state_t m_eState;
		int m_nPendingReplies;
		bool m_bLayoutNecessary;
		bool m_bWaitForLayoutReply;
		bigtime_t m_nLastLayout;
		ThumbCreator* m_ThumbCreator;
		bool m_Preview;
	};
}

#endif
