" Vim syntax file
" Language:		Thune
" Maintainer:	Karl Robillard <wickedsmoke@users.sf.net>
" Filenames:	*.t
" Last Change:	19th January 2006
" URL:			http://wsrebol.sf.net


" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" We are case insensitive
syn case ignore

" As per current users documentation
if version < 600
  set isk=@,48-57,?,!,.,',+,-,*,&,\|,=,_,~
else
  setlocal isk=@,48-57,?,!,.,',+,-,*,&,\|,=,_,~
endif

" Yer TODO highlighter
syn keyword	thuneTodo	contained TODO FIXME

" Comments
syn match       thuneComment	";.*$" contains=thuneTodo
syn region		thuneCommentB	start="/\*" end="\*/" contains=thuneTodo,thuneCommentB


" Words
syn match       thuneSetWord    ":\a\k*"
syn match       thuneGetWord    "\a\k*:"
syn match       thuneLitWord    "'\a\k*"
"syn match       thuneWord       "\a\k*"
"syn match       thuneWordPath   "[^[:space:]]/[^[:space]]"ms=s+1,me=e-1

" Booleans
syn keyword     thuneBoolean    true false on off yes no
syn keyword     thuneOpcode     nop drop dup dup2 over swap nip tuck
syn keyword     thuneOpcode     rot rot.r do
syn keyword     thuneOpcode     inc dec verify

" Values
" Integers
syn match       thuneInteger    "\<[+-]\=\d\+\('\d*\)*\>"
" Decimals
syn match       thuneDecimal    "[+-]\=\(\d\+\('\d*\)*\)\=[,.]\d*\(e[+-]\=\d\+\)\="
syn match       thuneDecimal    "[+-]\=\d\+\('\d*\)*\(e[+-]\=\d\+\)\="
" Time
syn match       thuneTime       "[+-]\=\(\d\+\('\d*\)*\:\)\{1,2}\d\+\('\d*\)*\([.,]\d\+\)\=\([AP]M\)\=\>"
syn match       thuneTime       "[+-]\=:\d\+\([.,]\d*\)\=\([AP]M\)\=\>"
" Dates
" DD-MMM-YY & YYYY format
syn match       thuneDate       "\d\{1,2}\([/-]\)\(Jan\|Feb\|Mar\|Apr\|May\|Jun\|Jul\|Aug\|Sep\|Oct\|Nov\|Dec\)\1\(\d\{2}\)\{1,2}\>"
" DD-month-YY & YYYY format
syn match       thuneDate       "\d\{1,2}\([/-]\)\(January\|February\|March\|April\|May\|June\|July\|August\|September\|October\|November\|December\)\1\(\d\{2}\)\{1,2}\>"
" DD-MM-YY & YY format
syn match       thuneDate       "\d\{1,2}\([/-]\)\d\{1,2}\1\(\d\{2}\)\{1,2}\>"
" YYYY-MM-YY format
syn match       thuneDate       "\d\{4}-\d\{1,2}-\d\{1,2}\>"
" DD.MM.YYYY format
syn match       thuneDate       "\d\{1,2}\.\d\{1,2}\.\d\{4}\>"
" Money
syn match       thuneMoney      "\a*\$\d\+\('\d*\)*\([,.]\d\+\)\="
" Strings
syn region      thuneString     oneline start=+"+ skip=+^"+ end=+"+ contains=thuneSpecialChar
syn region      thuneString     start=+{+ end=+}+ skip=+{[^}]*}+ contains=thuneSpecialChar
" Binary
syn region      thuneBinary     start=+\d*#{+ end=+}+ contains=thuneComment
" File
syn match       thuneFile       "%\(\k\+/\)*\k\+[/]\=" contains=thuneSpecialChar
syn region      thuneFile       oneline start=+%"+ end=+"+ contains=thuneSpecialChar
" URLs
syn match	thuneURL	"http://\k\+\(\.\k\+\)*\(:\d\+\)\=\(/\(\k\+/\)*\(\k\+\)\=\)*"
syn match	thuneURL	"file://\k\+\(\.\k\+\)*/\(\k\+/\)*\k\+"
syn match	thuneURL	"ftp://\(\k\+:\k\+@\)\=\k\+\(\.\k\+\)*\(:\d\+\)\=/\(\k\+/\)*\k\+"
syn match	thuneURL	"mailto:\k\+\(\.\k\+\)*@\k\+\(\.\k\+\)*"
" Issues
syn match	thuneIssue	"#\(\d\+-\)*\d\+"
" Tuples
syn match	thuneTuple	"\(\d\+\.\)\{2,}"

" Characters
syn region  thuneChar   oneline start="'" end="'" contains=thuneSpecialChar
syn match	thuneSpecialChar contained "\^[^[:space:][]"
syn match	thuneSpecialChar contained "%\d\+"


" Operators
" Math operators
"syn match       thuneMathOperator  "\(\*\{1,2}\|+\|-\|/\{1,2}\)"
"syn keyword     thuneMathFunction  abs absolute add arccosine arcsine arctangent cosine
"syn keyword     thuneMathFunction  divide exp log-10 log-2 log-e max maximum min
"syn keyword     thuneMathFunction  minimum multiply negate power random remainder sine
"syn keyword     thuneMathFunction  square-root subtract tangent
" Binary operators
"syn keyword     thuneBinaryOperator complement and or xor ~
" Logic operators
"syn match       thuneLogicOperator "[<>=]=\="
"syn match       thuneLogicOperator "<>"
"syn keyword     thuneLogicOperator not
"syn keyword     thuneLogicFunction all any
"syn keyword     thuneLogicFunction head? tail?
"syn keyword     thuneLogicFunction negative? positive? zero? even? odd?
"syn keyword     thuneLogicFunction binary? block? char? date? decimal? email? empty?
"syn keyword     thuneLogicFunction file? found? function? integer? issue? logic? money?
"syn keyword     thuneLogicFunction native? none? object? paren? path? port? series?
"syn keyword     thuneLogicFunction string? time? tuple? url? word?
"syn keyword     thuneLogicFunction exists? input? same? value?

" Datatypes
syn keyword     thuneType	unset! datatype! none! logic! word! set-word!
syn keyword     thuneType	get-word! lit-word! select! set-select! opcode!
syn keyword     thuneType	char! int! int64! decimal! coord! vec3!
syn keyword     thuneType	binary! string!  block! paren! path! setpath!
syn keyword     thuneType	slice! list! context!
syn keyword     thuneType	function! call! date! time! bitset! error! code!
"syn keyword     thuneTypeFunction type?

" Control statements
syn keyword     thuneStatement		try throw halt quit return recurse break
syn keyword     thuneConditional	ift iff either select case
syn keyword     thuneRepeat			iter forever each each.set
"for forall foreach forskip loop repeat while until do

" Series statements
"syn keyword     thuneStatement  change clear copy fifth find first format fourth free
syn keyword     thuneStatement  proc func
"head insert last match next parse past
"syn keyword     thuneStatement  pick remove second select skip sort tail third trim length?

" Context
"syn keyword     thuneStatement  alias bind use

" Object
"syn keyword     thuneStatement  import make make-object thune info?

" I/O statements
"syn keyword     thuneStatement  delete echo form format import input load mold prin
"syn keyword     thuneStatement  print probe read save secure send write
"syn keyword     thuneOperator   size? modified?

" Debug statement
"syn keyword     thuneStatement  help probe trace

" Constants
syn keyword     thuneConstant   none


" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_thune_syntax_inits")
  if version < 508
    let did_thune_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink thuneTodo     		Todo

  HiLink thuneStatement 	Statement
" HiLink thuneSetWord		Label
  HiLink thuneSetWord		Identifier
  HiLink thuneGetWord		Identifier
  HiLink thuneLitWord		Constant
  HiLink thuneConditional	Conditional
  HiLink thuneRepeat		Repeat

  HiLink thuneOperator		Operator
  HiLink thuneLogicOperator thuneOperator
  HiLink thuneLogicFunction thuneLogicOperator
  HiLink thuneMathOperator	thuneOperator
  HiLink thuneMathFunction 	thuneMathOperator
  HiLink thuneBinaryOperator thuneOperator
  HiLink thuneBinaryFunction thuneBinaryOperator

  HiLink thuneType     		Type

" HiLink thuneWord		Identifier
  HiLink thuneOpcode   	Operator
" HiLink thuneWordPath	thuneWord
  HiLink thuneFunction	Function

  HiLink thuneChar         Character
  HiLink thuneSpecialChar  SpecialChar
  HiLink thuneString	   String

  HiLink thuneNumber    Number
  HiLink thuneInteger   thuneNumber
  HiLink thuneDecimal   thuneNumber
  HiLink thuneTime      thuneNumber
  HiLink thuneDate      thuneNumber
  HiLink thuneBinary    thuneNumber
  HiLink thuneFile      thuneString
  HiLink thuneURL       thuneString
  HiLink thuneIssue     thuneNumber
  HiLink thuneTuple     thuneNumber
  HiLink thuneFloat     Float
  HiLink thuneBoolean   Boolean

  HiLink thuneConstant  Constant

  HiLink thuneComment   Comment
  HiLink thuneCommentB  Comment

  HiLink thuneError	    Error

  delcommand HiLink
endif


let b:current_syntax = "thune"

" vim: ts=4
