// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __WINDIA_ALERT_H__
#define __WINDIA_ALERT_H__

#include <vector>

#include <gui/window.h>
#include <gui/button.h>
#include <gui/stringview.h>
#include <gui/imageview.h>
#include <util/string.h>
#include <util/message.h>
#include "tableview.h"

class WinDiaAlert : public os::Window
{
public:
	enum AlertType { ALERT_INFO, ALERT_WARNING, ALERT_ERROR, ALERT_QUESTION, ALERT_NONE };

	WinDiaAlert( enum AlertType type, os::String title, os::String msg, ... );

	~WinDiaAlert();

	virtual void HandleMessage( os::Message* pcMessage );	

	virtual void FrameSized( const os::Point& delta );
	
	void Raise();

	int Go();
	void Go( os::Invoker * pcInvoker );

	static void ShowErrorAlert( os::String title, os::String msg );

private:
	void _AddButtons( va_list buttons );
	void _Layout();

	os::TableView* m_theTable;	
	os::StringView* m_Title;
	os::StringView* m_Message;
	os::ImageView* m_Icon;

	os::TableView* m_ButtonTable;
	std::vector< os::View* > m_ListOfButtons;

	os::Invoker*   m_pcInvoker;
    port_id    m_hMsgPort;
};

#endif
