// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __UNDO_H_
#define __UNDO_H_

#include <vector>
#include <util/string.h>

#include "object.h"

class UndoAction
{
public:
	UndoAction( os::String name );
	virtual ~UndoAction();

	virtual void Undo( Canvas* canvas,Document* doc ) {};
	virtual void Redo( Canvas* canvas,Document* doc ) {};

	void AddObject( Object* object );

	os::String GetName();
private:
	os::String m_Name;
protected:
	void _InvalidateCanvas( Canvas* canvas );
	std::vector< Object* > m_ListOfObjects;
};

class UndoAddObject : public UndoAction
{
public:
	UndoAddObject( os::String name, Object* object );
	UndoAddObject( os::String name );
	~UndoAddObject();

	void Undo( Canvas* canvas, Document* doc );
	void Redo( Canvas* canvas, Document* doc );
private:
};

class UndoEraseObjects : public UndoAction
{
public:
	UndoEraseObjects( os::String name );
	~UndoEraseObjects();

	void Undo( Canvas* canvas, Document* doc );
	void Redo( Canvas* canvas, Document* doc );
private:
};

class UndoModifyObjects : public UndoAction
{
public:
	UndoModifyObjects( os::String name );
	~UndoModifyObjects();

	void AddOriginalObject( Object* object ); 
	void AddTransformedObject( Object* object ); 

	void Undo( Canvas* canvas, Document* doc );
	void Redo( Canvas* canvas, Document* doc );
private:
	std::vector< Object* > m_ListOfTransformedObjects;
};

class Undo 
{
public:
	Undo();
	~Undo();

	void AddUndoAction( UndoAction* action );
	
	bool HasUndoObjects() { return m_ListOfUndoActions.size() > 0; };
	bool HasRedoObjects() { return m_ListOfRedoActions.size() > 0; };

	os::String GetUndoName();
	os::String GetRedoName();

	bool DoUndo( Canvas* canvas, Document* doc );
	bool DoRedo( Canvas* canvas, Document* doc );

private:
	std::vector< UndoAction* > m_ListOfUndoActions;
	std::vector< UndoAction* > m_ListOfRedoActions;
};
#endif

