// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TRANSFORM_H__
#define __TRANSFORM_H__

#include <gui/point.h>

class Transform
{
public:
	Transform();
	Transform( double v0, double v1, double v2, double v3, double v4, double v5 );
	~Transform();

	os::Point Calculate( os::Point value );

	void Translation( os::Point delta );
	void Rotation( double angle );
	void Scaling( double x, double y );
	void Scaling( double s );
	void FlipX();
	void FlipY();
	
private:
	void _Multiply( Transform& transform );

	double m_sx, m_shy, m_shx, m_sy, m_tx, m_ty;

	os::Point m_Translation;
};

#endif

