// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOLBOX_FRAME_H_
#define __TOOLBOX_FRAME_H_

#include <gui/frameview.h>

#include "tableview.h"

class ToolboxFrame : public os::FrameView
{
public:
	ToolboxFrame( const os::Rect& cFrame, const os::String& cName, const os::String& cLabel, 
				  uint32 nResizeMask = os::CF_FOLLOW_LEFT | os::CF_FOLLOW_TOP,
 		          uint32 nFlags = os::WID_WILL_DRAW | os::WID_CLEAR_BACKGROUND );
	~ToolboxFrame();

	void AddTableView( os::TableView* table );

	virtual void Paint( const os::Rect& cUpdate );
	virtual os::Rect GetFrame() const;
	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );

	virtual os::Point GetPreferredSize( bool bLargest ) const;

	void ShowFrame( bool show = true );
	bool IsFrameVisible();

	void ShowLabel( bool show = true );
	bool IsLabelVisible();

private:
	class Private;
	Private* m;
};

#endif
