// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "toolbox_frame.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class ToolboxFrame :: Private
{
public:
	Private(){};

	void _Layout( Rect cFrame )
	{	
		if( m_Table != NULL )
		{
			cFrame.Resize( 2, 2, -2, -2 );
			m_Table->SetFrame( cFrame );
		}
	}

	void _DrawRoundedFrame( View* view, Rect cSize )
	{
		Rect cFillRect = cSize;
		cFillRect.Resize( 1, 4, -1 , -4 );
		view->SetFgColor( 180, 180, 180 );
		view->DrawLine( Point( 0, cFillRect.top ), Point( 0, cFillRect.bottom ) );
		view->DrawLine( Point( cFillRect.right + 1, cFillRect.top ), Point( cFillRect.right + 1, cFillRect.bottom ) );
		view->DrawLine( Point( 4, 0 + cSize.top ), Point( cSize.right - 4, 0 + cSize.top ) );
		view->DrawLine( Point( 2, 1 + cSize.top ), Point( 3, 1 + cSize.top ) );
		view->DrawLine( Point( 1, 2 + cSize.top ), Point( 1, 3 + cSize.top ) );
		view->DrawLine( Point( cSize.right - 2, 1 + cSize.top ), Point( cSize.right - 3, 1 + cSize.top ) );
		view->DrawLine( Point( cSize.right - 1, 2 + cSize.top ), Point( cSize.right - 1, 3 + cSize.top ) );

		cFillRect.top = cSize.bottom - 3;
		cFillRect.bottom = cSize.bottom;
		view->SetFgColor( 180, 180, 180 );
		view->DrawLine( Point( 4, cFillRect.bottom - 0 ), Point( cSize.right - 4, cFillRect.bottom - 0 ) );
		view->DrawLine( Point( 2, cFillRect.bottom - 1 ), Point( 3, cFillRect.bottom - 1 ) );
		view->DrawLine( Point( 1, cFillRect.bottom - 2 ), Point( 1, cFillRect.bottom - 3 ) );
		view->DrawLine( Point( view->GetBounds().right - 2, cFillRect.bottom - 1 ), Point(  cSize.right - 3, cFillRect.bottom - 1 ) );
		view->DrawLine( Point( view->GetBounds().right - 1, cFillRect.bottom - 2 ), Point(  cSize.right - 1, cFillRect.bottom - 3 ) );
		view->DrawLine( Point( 4, cFillRect.bottom ), Point( cSize.right - 4, cFillRect.bottom ) );
	}


	bool m_ShowFrame;
	bool m_ShowLabel;

	String m_FrameLabel;
	TableView* m_Table;

	float m_FontHeight;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
ToolboxFrame :: ToolboxFrame( const Rect& cFrame, const String& cName, const String& cLabel, uint32 nResizeMask, uint32 nFlags ) : 
							  FrameView( cFrame, cName, cLabel, nResizeMask, nFlags )
{
	// Create the private class
	m = new Private();

	m->m_FrameLabel = cLabel;
	m->m_Table = NULL;
	m->m_ShowFrame = true;
	m->m_ShowLabel = true;

	// Calculate font height
	font_height tmp;	
	GetFontHeight( &tmp );
	m->m_FontHeight = tmp.ascender + tmp.descender;
}

ToolboxFrame :: ~ToolboxFrame()
{
	delete m;
}

void ToolboxFrame ::Paint( const os::Rect& cUpdate )
{
	Rect cBounds = GetBounds();

	View::Paint( cUpdate );

	if( m->m_ShowFrame )
	{
		if( m->m_ShowLabel )
			m->_DrawRoundedFrame( this, Rect( cBounds.left, cBounds.top + m->m_FontHeight / 2 + 3 , cBounds.right, cBounds.bottom ) );
		else
			m->_DrawRoundedFrame( this, Rect( cBounds.left, cBounds.top, cBounds.right, cBounds.bottom ) );
	}

	if( m->m_ShowLabel )
	{
		// Calculate position of framelabel
		Point pos = cBounds.LeftTop();
		pos.x += 10;
		pos.y += m->m_FontHeight;

		// Draw background (remove the frame)
		Rect r( pos.x - 2, pos.y - m->m_FontHeight - 1, pos.x + GetStringWidth( m->m_FrameLabel ) + 3, pos.y + 1 );
		FillRect( r, get_default_color( COL_NORMAL ) );

		// Draw label
		SetFgColor( 0, 0, 0 );
		DrawString( pos, m->m_FrameLabel );
	}
}

Rect ToolboxFrame :: GetFrame() const
{
	Rect cFrame = GetBounds();

//		cFrame.Resize( 5, m->m_FontHeight + 5 , -5, -2 );

	if( m->m_ShowFrame )
		cFrame.Resize( 5, 5 , -5, -2 );

	if( m->m_ShowLabel )
		cFrame.top = m->m_FontHeight + 5;

	return cFrame;
}

void ToolboxFrame :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	FrameView::SetFrame( cRect, bNotifyServer );
	m->_Layout( GetFrame() );
}

void ToolboxFrame :: AddTableView( TableView* table )
{
	m->m_Table = table;
	AddChild( table );
	m->_Layout( GetFrame() );
}

Point ToolboxFrame :: GetPreferredSize( bool bLargest ) const
{
	if( m->m_Table != NULL )
	{
		Point ret =  m->m_Table->GetPreferredSize( bLargest );

		// add also needed size for the frame
		ret.x += 10;
		ret.y += m->m_FontHeight + 5 + 2;

		// add border
		ret.x += 2 + 2;
		ret.y += 2 + 2;

		return ret;
	}

	return FrameView :: GetPreferredSize( bLargest );
}

void ToolboxFrame :: ShowFrame( bool show )
{
	m->m_ShowFrame = show;
}

bool ToolboxFrame :: IsFrameVisible()
{
	return m->m_ShowFrame;
}

void ToolboxFrame :: ShowLabel( bool show )
{
	m->m_ShowLabel = show;
}

bool ToolboxFrame :: IsLabelVisible()
{
	return m->m_ShowLabel;
}



