// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "toolbox_action.h"

using namespace os;

ToolboxAction :: ToolboxAction( const Rect& cFrame, const String& cName, uint32 nResizeMask, uint32 nFlags ) : ToolboxFrame( cFrame, cName, "Actions", nResizeMask, nFlags )
{
	m_Table = new TableView( Rect(), "", 0 , 0, true );
	m_Table->SetRowSpacings( 4 );
	AddChild( m_Table );
}


ToolboxAction :: ~ToolboxAction()
{
	for( uint i = 0 ; i < m_ListOfActionButtons.size() ; i++ )
		delete m_ListOfActionButtons[ i ];

	delete m_Table;
}

void ToolboxAction :: AddButton( String label, Image* bitmap, Message* msg, String description )
{
	ToolboxButton* tmp = new ToolboxButton( Rect(), label, bitmap, msg, description );
	m_ListOfActionButtons.push_back( tmp );

	m_Table->Resize( m_ListOfActionButtons.size() + 1, 1 );
	m_Table->Attach( tmp, 0, 1, m_Table->GetNumberOfRows() - 2, m_Table->GetNumberOfRows() - 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );
}

void ToolboxAction :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	ToolboxFrame::SetFrame( cRect, bNotifyServer );
	Layout();
}

void ToolboxAction :: SetTarget( Handler* pcMessenger )
{
	for( uint i = 0 ; i < m_ListOfActionButtons.size() ; i++ )
		m_ListOfActionButtons[ i ]->SetTarget( pcMessenger );
}

Point ToolboxAction :: GetPreferredSize( bool bLargest ) const
{
	Point p = ToolboxFrame :: GetPreferredSize( bLargest );
	p += m_Table->GetPreferredSize( bLargest );
	p += Point( 0, 6 );

	return p;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

void ToolboxAction :: Layout()
{
	Rect cFrame = GetFrame();
	m_Table->SetFrame( cFrame );
}

