// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "main.h"
#include "toolbox.h"
#include "sidebar_toolbox.h"

using namespace os;

Toolbox :: Toolbox( ToolboxSideBar* parent ) : View( Rect(), "Toolbox" )
{
	m_Parent = parent;
}

Toolbox :: ~Toolbox()
{
}

void Toolbox :: MouseUp( const Point& cPosition, uint32 nButtons, Message* pcData )
{
	View::MouseUp( cPosition, nButtons, pcData );

	ClearFocus( this );

}

void Toolbox :: ClearFocus( View* parent )
{
	if( parent == NULL )
		return;

	// Make sure parent doesnt have focus
	if( HasFocus() )
	{
		MakeFocus( false );
	}

	// Go through each child
	int i = 0;
	View* child;

	while( ( child = parent->GetChildAt( i ) ) != NULL )
	{
		ClearFocus( child );
		i++;
	}
}

void Toolbox :: Layout()
{
}

void Toolbox :: SetToolbox( Toolbox* tool )
{
	m_Parent->SetToolbox( tool );
}

void Toolbox :: SetMainToolbox()
{
	GET_DOCUMENT()->DeselectAllObjects();
	GET_CANVAS()->Refresh();
	SET_MAINTOOLBOX();
}

void Toolbox :: HandleMessage( Message* msg )
{
	HandleMessage( GET_CANVAS(), GET_DOCUMENT(), msg );
}

void Toolbox :: HandleMessage( Canvas* canvas, Document* doc, Message* msg )
{
}
