// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_line_state_0.h"
#include "common.h"
#include "windialogs/windia_alert.h"
#include "tool_line/tool_line.h"
#include "toolbox_button.h"
#include "toolbox_point.h"
#include "toolbox_action.h"
#include "tableview.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class LineState0 :: Private
{
public:
	Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum LineState0Message { MSG_CONTINUE, MSG_POINT, MSG_CANCEL };

	ToolboxPoint* m_StartPoint;
	ToolboxAction* m_Action;

	TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
LineState0 :: LineState0( Tool* theTool, ToolboxSideBar* toolbox ) : State( theTool ), Toolbox( toolbox )
{
	// Create the private class
	m = new Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_StartPoint = new ToolboxPoint( Rect(), "Start point", "X: ", "Y: ", new Message( Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_StartPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "circle.png" ), new Message( Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );
	m->m_Action->AddButton( "Continue", (Image*) LoadImage( "circle.png" ), new Message( Private::MSG_CONTINUE ) , "Continue from the last point " );

	State::SetToolbox( this );
}

LineState0 :: ~LineState0()
{
	delete m;
}

void LineState0 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_StartPoint->SetValue( coord );
}

void LineState0 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_StartPoint->ClearValue();
}

void LineState0 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_StartPoint->SetValue( coord );
}

String LineState0 :: GetStatusText()
{
	return String( "Select start point of the line" );
}

void LineState0 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	
	GetTool()->SetProperty( "first_point", coord );	
	GetTool()->SetProperty( "saved_point", coord );
	GetTool()->SetState( 1 );
}

void LineState0 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( GetFrame() );
}

void LineState0 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_StartPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void LineState0 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
	case Private::MSG_CANCEL:
		SetMainToolbox();
		break;
	case Private::MSG_CONTINUE: 
		{
			Point p;
			double tangent;

			if( doc->GetContinuePoint( p, tangent ) )
			{
				PointSelected( canvas, doc, p );
			}
			else
			{
				WinDiaAlert::ShowErrorAlert( "Line continue", "It is not possible to continue.\nYou need to have drawn at least one line or arc." );
			}
			break;
		}
	case Private::MSG_POINT:
		{
			Point p;

			if( pcMessage->FindPoint( "value", &p ) == EOK )
				PointSelected( canvas, doc, p );
		
			break;
		}
	}
}

