// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_create_state_0.h"
#include "common.h"
#include "main.h"
#include "tool_line/tool_line.h"
#include "tool_circle/tool_circle.h"
#include "tool_arc/tool_arc.h"
#include "tool_create.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////

CreateState0 :: CreateState0( Tool* theTool, ToolboxSideBar* toolbox ) : StateToolSelect( theTool, toolbox )
{	
	AddMainButton();
	AddButton( new ToolLine( toolbox ) );
	AddButton( new ToolCircle( toolbox ) );
	AddButton( new ToolArc( toolbox ) );
}

CreateState0 :: ~CreateState0()
{
}

