// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_arc_state_1.h"
#include "common.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class ArcState1 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum ArcState1Message { MSG_CLOSE, MSG_POINT, MSG_CANCEL, MSG_CENTER, MSG_ENDPOINT };

	ToolboxPoint* m_MidPoint;
	ToolboxAction* m_Action;

	TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
ArcState1 :: ArcState1( ToolArc* theTool, ToolboxSideBar* toolbox ) : State( theTool ), Toolbox( toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_MidPoint = new ToolboxPoint( Rect(), "Second point", "X: ", "Y: ", new Message( _Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_MidPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );
	m->m_Action->AddButton( "Center", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_CENTER ) , "Specify the center point " );
	m->m_Action->AddButton( "End point", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_ENDPOINT ) , "Specify the end point " );

	State::SetToolbox( this );
}

ArcState1 :: ~ArcState1()
{	
	delete m;
}

void ArcState1 :: Init( Canvas* canvas, Document* doc )
{
	canvas->PrepareForXORMode();
}

void ArcState1 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	m->m_MidPoint->SetValue( coord );
}

void ArcState1 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	canvas->Undraw();
	m->m_MidPoint->ClearValue();
}

void ArcState1 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	m->m_MidPoint->SetValue( coord );

	canvas->SetStyle( doc->GetCurrentStyle() );
	canvas->DrawLine( GetTool()->GetPropertyAsPoint( "first_point" ), coord, true );
}

String ArcState1 :: GetStatusText()
{
	return String( "Select second point of the arc" );
}

void ArcState1 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( GetTool()->GetPropertyAsPoint( "first_point" ), coord );
	canvas->Undraw();
	GetTool()->SetProperty( "second_point", coord );
	GetTool()->SetState( 2 );
}

void ArcState1 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void ArcState1 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_MidPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void ArcState1 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_CENTER:
		{
			GetTool()->SetState( 12 );
			break;
		}
		case _Private::MSG_ENDPOINT:
		{
			GetTool()->SetState( 8 );
			break;
		}

		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}

