// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __STATE_H__
#define __STATE_H__

#include <gui/point.h>
#include <util/string.h>

#include "toolbox.h"
#include "document.h"

class Tool;
class Canvas;

class State
{
public:
	State( Tool* tool ) { m_Toolbox = NULL; m_Tool = tool; };
	virtual ~State() { delete m_Toolbox; };

	virtual void Init( Canvas* canvas, Document* doc ) {};

	virtual bool AllowMouseBox( Canvas* canvas, Document* doc, os::Point coord ) { return false; }

	virtual void GotFocus( Canvas* canvas, Document* doc, os::Point coord ) {};
	virtual void LostFocus( Canvas* canvas, Document* doc, os::Point coord ) {};

	virtual void PointSelected( Canvas* canvas, Document* doc, os::Point coord ) {};

	virtual void MouseMove( Canvas* canvas, Document* doc, os::Point coord ) {};

	virtual void MouseBox( Canvas* canvas, Document* doc, os::Rect box ) {};	

	void SetToolbox( Toolbox* box) { m_Toolbox = box; };
	Toolbox* GetToolbox() 		   { return m_Toolbox; };

	Tool* GetTool() { return m_Tool; };

	virtual os::String GetStatusText() { return os::String(""); };

private:
	Toolbox* m_Toolbox;
	Tool* m_Tool;
};

#endif
