// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "preferences.h"

using namespace os;

Preferences :: Preferences() : Settings()
{
}

Preferences :: ~Preferences()
{
}

void Preferences :: SetSelectionSensity( int value )
{
	SetInt8( "selection_sensity", value );
}

int Preferences :: GetSelectionSensity()
{
	int8 sens;

	if( FindInt8( "selection_sensity", &sens ) != EOK )
		sens = 5;

	return sens;
}

void Preferences :: SetExpertMode( bool value )
{
	SetBool( "expert_mode", value );
}

bool Preferences :: IsExpertMode()
{
	bool mode = false;

	FindBool( "expert_mode", &mode );

	return mode;
}

int Preferences :: GetAngleUnit()
{
	int8 unit = 1;

	FindInt8( "angle_unit", &unit );

	return unit;
}

void Preferences :: SetAngleUnit( int unit )
{
	SetInt8( "angle_unit", unit );
}
