// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __OBJECT_H_
#define __OBJECT_H_

#include <vector>

#include <gui/rect.h>
#include <gui/point.h>
#include <util/variant.h>

#include "canvas.h"
#include "style.h"
#include "transform.h"

class Canvas;


class Object
{
public:
	enum ObjectSnapType { SnapEndPoint, SnapMidPoint, SnapCenPoint, SnapNeaPoint, SnapQuaPoint };

	Object();
	virtual ~Object();

	virtual Style& GetStyle() { return m_Style; };
	virtual void SetStyle( Style& style ) {  m_Style = style; };

	virtual void Erase( Canvas* canvas );
	virtual void Draw( Canvas* canvas, bool save_background = false, bool update_server = true );
	virtual void Draw( Canvas* canvas, Transform& transform, bool save_background = false, bool update_server = true );
	
	virtual void DoTransform( Transform& transform );

	virtual os::Rect GetBounds();

	virtual bool HitCheck( os::Point coord, double sens );

	virtual Object* Duplicate();

	void SetSelected( bool sel );
	bool IsSelected();

	virtual void SetLayer( Layer* layer );
	Layer* GetLayer();

	virtual bool SetProperty( int which, os::Variant& value );
	virtual bool GetProperty( int which, os::Variant& value );

	virtual bool GetSnapPoint( int type, os::Point p, std::vector< os::Point >& list );

	os::String SaveAttributes();

	virtual os::String Save();
protected:
	Style m_Style;
	
	Layer* m_Layer;

	bool m_Selected;
};

#endif
