// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __MAIN_H_
#define __MAIN_H_

#include <string>

#include <util/application.h>

#include "appwindow.h"

#define SET_STATUSTEXT( x )  oCADisApp::GetAppWindow()->SetStatusbar( x )
#define SET_STATE( x )  oCADisApp::GetAppWindow()->SetCurrentState( x )
#define CLEAR_STATE( x ) oCADisApp::GetAppWindow()->ClearCurrentState( x )
#define GET_STATE()  oCADisApp::GetAppWindow()->GetCurrentState()
#define GET_CANVAS()  oCADisApp::GetAppWindow()->GetCanvas()
#define GET_DOCUMENT()  oCADisApp::GetAppWindow()->GetCurrentDocument()
#define SET_MAINTOOLBOX()  oCADisApp::GetAppWindow()->SetMainToolbox()
#define GET_DIALOGADDLAYER()  oCADisApp::GetAppWindow()->GetDialogAddLayer()
#define GET_PREFERENCES()  oCADisApp::GetAppWindow()->GetPreferences()

class oCADisApp : public os::Application
{
	public:
		oCADisApp(int argc, char* argv[]);   
	
		static AppWindow* GetAppWindow() { return m_AppWindow; };
	private:
		// The main window
		static AppWindow* m_AppWindow;
};

#endif

