// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "layer.h"

using namespace os;
using namespace std;

Layer :: Layer( String name, Pattern* pattern )
{
	m_Name = name;
	m_Visible = true;
	m_Editable = true;

	// Set up default style
	m_Style.SetLineWidthType( Style::BY_USER );   // <- NOTE! Layer must always have style BY_USER!
	m_Style.SetLineWidth( 0.0f );

	m_Style.SetColourType( Style::BY_USER );
	m_Style.SetColour( 0.0f, 0.0f, 0.0f );

	m_Style.SetPatternType( Style::BY_USER );
	m_Style.SetPattern( pattern );

}

Layer :: Layer( String name, double r, double g, double b, double linewidth, 
				Pattern* pattern, bool visible, bool editable )
{

	m_Name = name;
	m_Visible = visible;
	m_Editable = editable;

	// Set style
	m_Style.SetLineWidthType( Style::BY_USER );   // <- NOTE! Layer must always have style BY_USER!
	m_Style.SetLineWidth( linewidth );

	m_Style.SetColourType( Style::BY_USER );
	m_Style.SetColour( r, g, b );

	m_Style.SetPatternType( Style::BY_USER );
	m_Style.SetPattern( pattern );
}

Layer :: Layer( String name, double r, double g, double b, double linewidth, 
				String pattern, bool visible, bool editable )
{
	m_Name = name;
	m_Visible = visible;
	m_Editable = editable;

	// Set style
	m_Style.SetLineWidthType( Style::BY_USER );   // <- NOTE! Layer must always have style BY_USER!
	m_Style.SetLineWidth( linewidth );

	m_Style.SetColourType( Style::BY_USER );
	m_Style.SetColour( r, g, b );

	m_Style.SetPatternType( Style::BY_USER );
	m_Style.SetPattern( pattern );
}

Layer :: Layer( String name, Color32_s colour, double linewidth, Pattern* pattern, bool visible, bool editable )
{
	m_Name = name;
	m_Visible = visible;
	m_Editable = editable;

	// Set style
	m_Style.SetLineWidthType( Style::BY_USER );   // <- NOTE! Layer must always have style BY_USER!
	m_Style.SetLineWidth( linewidth );

	m_Style.SetColourType( Style::BY_USER );
	m_Style.SetColour( colour.red / 255.0f, colour.blue / 255.0f, colour.green / 255.0f );

	m_Style.SetPatternType( Style::BY_USER );
	m_Style.SetPattern( pattern );
}

Layer :: ~Layer()
{
	for( uint i = 0 ; i < m_ListOfObjects.size() ; i++ )
		delete m_ListOfObjects[ i ];
}

void Layer :: AddObject( Object* obj )
{
	m_ListOfObjects.push_back( obj );
} 

bool Layer :: RemoveObject( Object* obj )
{
	for( vector< Object* >::iterator it = m_ListOfObjects.begin(); it != m_ListOfObjects.end() ; it++ )
	{
		if( *it == obj )		
		{	
			m_ListOfObjects.erase( it );
			return true;
		}			
	}

	return false;
}

bool Layer :: ReplaceObject( Object* old_obj, Object* new_obj )
{
	for( vector< Object* >::iterator it = m_ListOfObjects.begin(); it != m_ListOfObjects.end() ; it++ )
	{
		if( *it == old_obj )		
		{	
			*it = new_obj;			
			return true;
		}			
	}

	return false;
}

void Layer :: Redraw( Canvas* canvas )
{
	for( uint i = 0 ; i < m_ListOfObjects.size(); i++ )
		m_ListOfObjects[ i ]->Draw( canvas );
}

void Layer :: Erase( Canvas* canvas )
{
	for( uint i = 0 ; i < m_ListOfObjects.size(); i++ )
		m_ListOfObjects[ i ]->Erase( canvas );
}

String Layer :: Save()
{
	String d;
	double r, g, b;

	m_Style.GetColour( r, g, b );

	// Layer name, r, g, b, line width, pattern name, visible, editable
	d.Format( "L, \"%s\", %f, %f, %f, %f, \"%s\", %d, %d\n", GetName().c_str(), r, g, b, m_Style.GetLineWidth(), m_Style.GetPattern()->GetName().c_str(), IsVisible(), IsEditable() );

	return d;
}

bool Layer :: ObjectExists( Object* object )
{
	for( int i = 0 ; i < GetObjectCount() ; i++ )
	{ 
		if( GetObject( i ) == object ) 
			return true; 
	}

	return false;
}
