// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "filters/filter_ocadis_old.h"
#include "main.h"
#include "cadmath.h"
#include "object_line.h"
#include "object_circle.h"
#include "object_arc.h"

using namespace os;
using namespace std;
using namespace CadMath;

bool FilteroCADisOld :: Identify( String& fs, os::String r )
{
	return( r.find( "H,\"oCADis 1.0\"" ) != string::npos );
}
	
void FilteroCADisOld :: Open( String& path, Document& doc )
{
	FILE* fp;
	int num;
	Layer* current_layer = NULL;

	fp = fopen( path.c_str(), "r" );

  	if( fp==NULL )
		throw String( "Cannot open file" );    



	while( _ReadLine( fp, &num, arg[ 0 ] ) )
    {
printf( "Parsing line %c\n", arg[0][0] );

		switch( arg[ 0 ][ 0 ] )
		{
			case 'V':  // Viewport
				GET_CANVAS()->SetViewport( Point( Strtod( arg[ 1 ] ), Strtod( arg[ 2 ] ) ), Strtod( arg[ 3 ] ) );
	  			break;
			case 'G':  /* Grid data */
				doc.SetOrthoMode( (enum Document::OrthoMode) Strtod( arg[ 1 ] ) );
				doc.SetGridActive( (int) Strtod( arg[ 2 ] ) );
				doc.SetGridSkip( Point( Strtod( arg[ 3 ] ), Strtod( arg[ 4 ] ) ) );
				break;
			case 'N':  /* Snap data */
				doc.SetSnapActive( (int) Strtod( arg[ 1 ] ) );
				doc.SetSnapOrigo( Point( Strtod( arg[ 2 ] ), Strtod( arg[ 3 ] ) ) );
				doc.SetSnapDistance( Point( Strtod( arg[ 4 ] ), Strtod( arg[ 5 ] ) ) );
				doc.SetSnapAngle( Strtod( arg[ 6 ] ) );
				break;
			case 'S':  // Linestyle
				if( num == 4 )  // Line solid
				{
					Pattern* pattern = new Pattern( String( arg[ 2 ] ) );
					doc.AddPattern( pattern );
				}
				else
				{
					Pattern* pattern = new Pattern( String( arg[ 2 ] ) );
					doc.AddPattern( pattern );
					pattern->SetScale( Strtod( arg[ 3 ] ) );
					for( int i = 0 ; i < (int)Strtod( arg[ 4] ) ; i++ )
						pattern->AddPattern( Strtod( arg[ i + 5 ] ) );
	    		}
				break;


			case 'L':  /* Layer */
				current_layer = new Layer( String( arg[ 1 ] ), 	// Name of layer
										   Strtod( arg[ 2 ] ), Strtod( arg[ 3 ] ), Strtod( arg[ 4 ] ), // Colour of layer
										   Strtod( arg[ 5 ] ),  		// Linewidth of layer
										   doc.GetPattern( (int) Strtod( arg[ 6 ] ) ),	// Linepattern
										   (bool) Strtod( arg[ 7 ] ), // Visible
										   (bool) Strtod( arg[ 8 ] ) ); // Editable
				doc.AddLayer( current_layer );
				doc.SetCurrentLayer( current_layer );
				break;

			case 'O':  /* Object */
	  			switch( arg[ 0 ][ 1 ] )
	    		{
					case 'L':  // Line
					{
						Style style;
						Object* obj = new ObjectLine( Point( Strtod( arg[ 2 ] ), Strtod( arg[ 3 ] ) ), Point( Strtod( arg[ 4 ] ), Strtod( arg[ 5 ] ) ) );

						_LoadAttribute( doc, obj, 6, style );
						obj->SetStyle( style );
						obj->SetLayer( current_layer );
						current_layer->AddObject( obj );
						break;
	 				}	
					case 'C':  // Circle
					{
						Style style;
						Object* obj = new ObjectCircle( Point( Strtod( arg[ 2 ] ), Strtod( arg[ 3 ] ) ), Strtod( arg[ 4 ] ) );

						_LoadAttribute( doc, obj, 5, style );
						obj->SetStyle( style );
						obj->SetLayer( current_layer );
						current_layer->AddObject( obj );
						break;
	 				}	
					case 'A':  // Arc
					{
						Style style;
						Object* obj = new ObjectArc( Point( Strtod( arg[ 2 ] ), Strtod( arg[ 3 ] ) ), Strtod( arg[ 4 ] ), 
													 ConvertDeg2Rad( Strtod( arg[ 5 ] ) ), ConvertDeg2Rad( Strtod( arg[ 6 ] ) ) );

						_LoadAttribute( doc, obj, 7, style );
						obj->SetStyle( style );
						obj->SetLayer( current_layer );
						current_layer->AddObject( obj );
						break;
	 				}	
				}
				break;
	    	}
 	}
	
	// We need to swap the Y-coordinates
	Rect bounds = doc.GetBoundingBox();
	Transform t;

	t.Translation( Point( - ( bounds.Width() / 2 + bounds.left ), ( bounds.Height() / 2 + bounds.top ) ) );
	t.FlipY();
	t.Translation( Point( bounds.Width() / 2 + bounds.left, bounds.Height() / 2 + bounds.top ) );

	for( int i = 0 ; i < doc.GetLayerCount() ; i++ )
	{
		Layer* layer = doc.GetLayer( i );

		for( int j = 0 ; j < layer->GetObjectCount() ; j++ )
		{
			Object* obj = layer->GetObject( j );
			obj->DoTransform( t );

			if( typeid( *obj ) == typeid( ObjectArc ) )
			{
				ObjectArc* arc = dynamic_cast< ObjectArc* >( obj );
				if( arc != NULL )
				{
					// Swap start and end angle
					Variant start;
					arc->GetProperty( 2, start );	// Start angle

					Variant end;
					arc->GetProperty( 3, end );	// End angle

					arc->SetProperty( 2, end );
					arc->SetProperty( 3, start );
				}
			}
		}
	}
	
	// Zoom box
	GET_CANVAS()->ZoomBox( bounds );

	// Set up a few pointers
	// Should be moved!
	doc.SetCurrentLayer( doc.GetLayer( 0 ) );
}


///////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
///////////////////////////////////////////////////////////////////////////////////////

void FilteroCADisOld :: _LoadAttribute( Document& doc, Object* obj, int sarg, Style& style )
{
	int index;

	// Get colour of object
	if( arg[ sarg ][ 0 ] == 'B' )  
	{
		style.SetColourType( Style::BY_BLOCK );
		index = 0;
	}
	else if( arg[ sarg ][ 0 ] == 'L' )  
    {
		style.SetColourType( Style::BY_LAYER );
		index = 0;
	}
  	else
	{
		style.SetColourType( Style::BY_USER );
		style.SetColour( Strtod( arg[ sarg + 1 ] ), Strtod( arg[ sarg + 2 ] ), Strtod( arg[ sarg + 3 ] ) );
		index=3;
    }
  
	// Get linestyle of object
	if( arg [ sarg + 1 + index ][ 0 ] == 'B' )
		style.SetPatternType( Style::BY_BLOCK );
  	else if( arg[ sarg + 1 + index ][ 0 ] == 'L' )
		style.SetPatternType( Style::BY_LAYER );   
	else
	{
		style.SetPatternType( Style::BY_USER );         
		style.SetPattern( doc.GetPattern( (int) Strtod( arg[ sarg + 2 + index ] ) ) );
  	    index++;
	}
  
	// Get linewidth of object
	if( arg[ sarg + 2 + index ][ 0 ] == 'B' )
		style.SetLineWidthType( Style::BY_BLOCK );
	else if( arg[ sarg + 2 + index ][ 0 ] == 'L' )
		style.SetLineWidthType( Style::BY_LAYER );
	else
	{
		style.SetLineWidthType( Style::BY_USER );
		style.SetLineWidth( Strtod( arg[ sarg + 3 + index ] ) );
    }  
}

bool FilteroCADisOld :: _ReadLine( FILE *fp, int *num, char *array )
{
	char buffer[ 300 ];
	int i, j;
	bool exit = false;
	bool citat = false;

	fgets(buffer,300,fp);

	if( !strcmp( buffer,"EOF" ) || feof( fp ) )
		return false;

	i = j = *num = 0;

	while( !exit )
	{

	    if( buffer[ i ] == '\0' || buffer[ i ] == '\n' )
		{
			array[ (*num) * 50 + j ] = '\0';

			(*num)++;

			exit = true;
		}
    	else if( ( buffer[ i ] == ',' ) && ( !citat ) )
		{
			array[ ( *num ) * 50 + j ] = '\0';

			(*num)++;
			j = 0;
		}
		else if( buffer[i] == '\"' )
		{
			citat=!citat;
	    }
    	else
		{
			if( buffer[ i ] != ' ' && !citat )
			{
	        	array[ *num * 50 + j] = buffer[ i ];
    	    	j++;
			}
			else if( citat )
			{
				array[ *num * 50 + j ] = buffer[ i ];
				j++;
			}
		}
		
		i++;
	}

	return true;
}

