// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DIALOG_STYLE_H__
#define __DIALOG_STYLE_H__

#include <gui/button.h>
#include <gui/radiobutton.h>
#include <gui/dropdownmenu.h>

#include "toolbox_frame.h"
#include "colour_button.h"
#include "tableview.h"
#include "rtsltextview.h"
#include "dialogs/dialog.h"

class DialogStyle : public Dialog
{
public:
	DialogStyle( DialogSideBar* parent );
	~DialogStyle();

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual void HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage );
	void AllAttached( void );
	void Init( Document* doc );

private:
	enum StyleMessage {	MSG_COLOUR_LAYER, MSG_COLOUR_BLOCK, MSG_COLOUR_USER, MSG_COLOUR,
						MSG_WIDTH_LAYER, MSG_WIDTH_BLOCK, MSG_WIDTH_USER, MSG_WIDTH,
						MSG_PATTERN_LAYER, MSG_PATTERN_BLOCK, MSG_PATTERN_USER, MSG_PATTERN };

	void _Layout();
	void _Update( Document* doc );
	void _UpdatePattern( Document* doc );

	// Colour frame
	ToolboxFrame* m_ColourFrame;
	os::TableView* m_ColourTable;
	os::RadioButton* m_ColourLayer;
	os::RadioButton* m_ColourBlock;
	os::RadioButton* m_ColourUser;
	ColourButton* m_Colour;

	// Linewidth
	ToolboxFrame* m_WidthFrame;
	os::TableView* m_WidthTable;
	os::RadioButton* m_WidthLayer;
	os::RadioButton* m_WidthBlock;
	os::RadioButton* m_WidthUser;
	RTSLTextView* m_Width;
	
	// Linepattern
	ToolboxFrame* m_PatternFrame;
	os::TableView* m_PatternTable;
	os::RadioButton* m_PatternLayer;
	os::RadioButton* m_PatternBlock;
	os::RadioButton* m_PatternUser;	
	os::DropdownMenu* m_Pattern;

	// The table
	os::TableView* m_Table;
};

#endif
