// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "toolbox_navigation.h"
#include "common.h"
#include "messages.h"
#include "main.h"

using namespace os;

ToolboxNavigation :: ToolboxNavigation( const Rect& cFrame, const String& cName, ToolboxSideBar* toolbox, uint32 nResizeMask, uint32 nFlags ) : ToolboxFrame( cFrame, cName, "Navigation", nResizeMask, nFlags )
{
	m_Toolbox = toolbox;

	m_Table = new TableView( Rect(), "", 0 , 0, true );
	m_Table->SetRowSpacings( 4 );
	AddChild( m_Table );

	AddButton( "Main", (Image*) LoadImage( "first.png" ), "Returns to main toolbox", new Message( MSG_MAIN_TOOLBOX ) );
}

ToolboxNavigation :: ~ToolboxNavigation()
{
	for( uint i = 0 ; i < m_ListOfActionButtons.size() ; i++ )
		delete m_ListOfActionButtons[ i ];

	delete m_Table;
}

void ToolboxNavigation :: AddButton( String label, Image* bitmap, String description, Toolbox* box )
{
	Message* msg = new Message( MSG_TOOLBOX );
	msg->AddPointer( "toolbox", (void*) box );

	AddButton( label, bitmap, description, msg, box );
}

void ToolboxNavigation :: AddButton( String label, Image* bitmap, String description, Message* msg, Toolbox* box )
{
	ToolboxButton* tmp = new ToolboxButton( Rect(), label, bitmap, msg, description );
	m_ListOfActionButtons.push_back( tmp );

	m_Table->Resize( m_ListOfActionButtons.size(), 1 );
	m_Table->Attach( tmp, 0, 1, m_Table->GetNumberOfRows() - 1, m_Table->GetNumberOfRows(), ( TABLE_EXPAND | TABLE_FILL ), 0 );
}

void ToolboxNavigation :: AddButton( String label, Image* bitmap, String description, Message* msg )
{
	ToolboxButton* tmp = new ToolboxButton( Rect(), label, bitmap, msg, description );
	m_ListOfActionButtons.push_back( tmp );

	m_Table->Resize( m_ListOfActionButtons.size(), 1 );
	m_Table->Attach( tmp, 0, 1, m_Table->GetNumberOfRows() - 1, m_Table->GetNumberOfRows(), ( TABLE_EXPAND | TABLE_FILL ), 0 );
}

void ToolboxNavigation :: AddButton( String label, Image* bitmap, String description, State* state )
{
	Message* msg = new Message( MSG_TOOLBOX );
	msg->AddPointer( "state", (void*) state );

	ToolboxButton* tmp = new ToolboxButton( Rect(), label, bitmap, msg, description );
	m_ListOfActionButtons.push_back( tmp );

	m_Table->Resize( m_ListOfActionButtons.size(), 1 );
	m_Table->Attach( tmp, 0, 1, m_Table->GetNumberOfRows() - 1, m_Table->GetNumberOfRows(), ( TABLE_EXPAND | TABLE_FILL ), 0 );
}

void ToolboxNavigation :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	ToolboxFrame::SetFrame( cRect, bNotifyServer );
	Layout();
}

void ToolboxNavigation :: AllAttached( void )
{
	for( uint i = 0 ; i < m_ListOfActionButtons.size() ; i++ )
		m_ListOfActionButtons[ i ]->SetTarget( this );
}

Point ToolboxNavigation :: GetPreferredSize( bool bLargest ) const
{
	Point p = ToolboxFrame :: GetPreferredSize( bLargest );
	p += m_Table->GetPreferredSize( bLargest );
	p += Point( 0, 6 );

	return p;
}

void ToolboxNavigation :: HandleMessage( Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case MSG_TOOLBOX:
		{
			Toolbox* toolbox;
			State* state;

			if( pcMessage->FindPointer( "toolbox", (void **) &toolbox ) == EOK && m_Toolbox != NULL )
				m_Toolbox->SetToolbox( toolbox );

			if( pcMessage->FindPointer( "state", (void **) &state ) == EOK )
				SET_STATE( state );

			break;
		}
		case MSG_MAIN_TOOLBOX:
		{
printf( "rjo\n" );
		//	if( m_Toolbox != NULL )
		//		m_Toolbox->SetMainToolbox();
			break;
		}
	}
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E   M E T H O D S
//
/////////////////////////////////////////////////////////////////////////////////////////////////////

void ToolboxNavigation :: Layout()
{
	Rect cFrame = GetFrame();
	m_Table->SetFrame( cFrame );
}

