// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "toolbox_button.h"

using namespace os;

ToolboxButton :: ToolboxButton( const Rect& cFrame, String label, Image* bitmap, Message* msg, String description, uint32 nResizeMask, uint32 nFlags ) 
							    : Button( cFrame, "", "", msg, nResizeMask, nFlags )
{
	m_HeadLine = label;
	m_Image = bitmap;
	m_Description = description;
	m_MouseOver = false;

	// Calculate font height
	font_height tmp;	
	GetFontHeight( &tmp );
	m_FontHeight = tmp.ascender + tmp.descender;
}

ToolboxButton :: ~ToolboxButton()
{
	delete m_Image;
}

void ToolboxButton :: AllDetached()
{
	m_MouseOver = false;
}

void ToolboxButton :: MouseMove( const Point& cNewPos, int nCode, uint32 nButtons, Message* pcData )
{
	Button::MouseMove( cNewPos, nCode, nButtons, pcData ); 

	if( nCode == MOUSE_EXITED )
	{
		if( m_MouseOver )
		{
			m_MouseOver = false;
			Invalidate();
			Flush();
		}
	}
	else
	{
		bool mouseover = GetBounds().DoIntersect( cNewPos );

		if( mouseover != m_MouseOver )
		{
			m_MouseOver = mouseover;
			Invalidate();
			Flush();
		}
	}
}


void ToolboxButton :: Paint( const Rect& cUpdate )
{
	SetDrawingMode( DM_COPY );

	float offset = 4.0f;
	Rect cFrame = GetBounds();

	// Draw selection if mouse is inside the button
	if( m_MouseOver )
	{
		Rect cFillRect = GetBounds();
		cFillRect.bottom = 3;
		cFillRect = GetBounds();
		cFillRect.Resize( 1, 4, -1 , -4 );
		FillRect( cFillRect, get_default_color( COL_ICON_SELECTED ) );

	
		SetFgColor( get_default_color( COL_ICON_SELECTED ) );
		DrawLine( Point( 4, 1 ), Point( GetBounds().right - 4, 1 ) );
		DrawLine( Point( 2, 2 ), Point( GetBounds().right - 2, 2 ) );
		DrawLine( Point( 2, 3 ), Point( GetBounds().right - 2, 3 ) );

		cFillRect.top = GetBounds().bottom - 3;
		cFillRect.bottom = GetBounds().bottom;
		FillRect( cFillRect, get_default_color( COL_NORMAL ) );

		SetFgColor( get_default_color( COL_ICON_SELECTED ) );
		DrawLine( Point( 4, cFillRect.bottom - 1 ), Point( GetBounds().right - 4, cFillRect.bottom - 1 ) );
		DrawLine( Point( 2, cFillRect.bottom - 2 ), Point( GetBounds().right - 2, cFillRect.bottom - 2 ) );
		DrawLine( Point( 2, cFillRect.bottom - 3 ), Point( GetBounds().right - 2, cFillRect.bottom - 3 ) );
	}
	else
		FillRect( cFrame, get_default_color( COL_NORMAL ) );

	// Always the draw the frame around the button
	DrawRoundedFrame();

	// Draw the image
	SetDrawingMode( DM_BLEND );
	m_Image->Draw( Point( cFrame.left + offset, cFrame.top + cFrame.Height() / 2 - m_Image->GetSize().y / 2 ), this );
	SetDrawingMode( DM_COPY );

	// Draw the headline
	SetFgColor( 0, 0, 0 );
	GetFont()->SetFlags( FPF_BOLD | FPF_SMOOTHED ); // Doesnt FPF_BOLD work?
	DrawString( Point( cFrame.left + offset * 3 + m_Image->GetSize().x, cFrame.top + offset + m_FontHeight ), m_HeadLine );

	// Draw line
	SetFgColor( 0, 0, 0 );
	DrawLine( Point( cFrame.left + offset * 3 + m_Image->GetSize().x, cFrame.top + offset * 2 + m_FontHeight + 1 ), Point( cFrame.right - offset, cFrame.top + offset * 2 + m_FontHeight + 1 ) );

	// Draw the description
	SetFgColor( 25, 25, 25 );
	GetFont()->SetFlags( FPF_SMOOTHED );
	DrawText( Rect( cFrame.left + offset * 3 + m_Image->GetSize().x, cFrame.top + offset * 2 + m_FontHeight * 2 + 2,  cFrame.right - offset, cFrame.bottom - offset ), m_Description, DTF_WRAP_SOFT | DTF_ALIGN_TOP | DTF_ALIGN_LEFT );
}

void ToolboxButton :: DrawRoundedFrame()
{
	Rect cFillRect = GetBounds();
	cFillRect.Resize( 1, 4, -1 , -4 );
	SetFgColor( 180, 180, 180 );
	DrawLine( Point( 0, cFillRect.top ), Point( 0, cFillRect.bottom ) );
	DrawLine( Point( cFillRect.right + 1, cFillRect.top ), Point( cFillRect.right + 1, cFillRect.bottom ) );
	DrawLine( Point( 4, 0 ), Point( GetBounds().right - 4, 0 ) );
	DrawLine( Point( 2, 1 ), Point( 3, 1 ) );
	DrawLine( Point( 1, 2 ), Point( 1, 3 ) );
	DrawLine( Point( GetBounds().right - 2, 1 ), Point( GetBounds().right - 3, 1 ) );
	DrawLine( Point( GetBounds().right - 1, 2 ), Point( GetBounds().right - 1, 3 ) );

	cFillRect.top = GetBounds().bottom - 3;
	cFillRect.bottom = GetBounds().bottom;
	SetFgColor( 180, 180, 180 );
	DrawLine( Point( 4, cFillRect.bottom - 0 ), Point( GetBounds().right - 4, cFillRect.bottom - 0 ) );
	DrawLine( Point( 2, cFillRect.bottom - 1 ), Point( 3, cFillRect.bottom - 1 ) );
	DrawLine( Point( 1, cFillRect.bottom - 2 ), Point( 1, cFillRect.bottom - 3 ) );
	DrawLine( Point( GetBounds().right - 2, cFillRect.bottom - 1 ), Point(  GetBounds().right - 3, cFillRect.bottom - 1 ) );
	DrawLine( Point( GetBounds().right - 1, cFillRect.bottom - 2 ), Point(  GetBounds().right - 1, cFillRect.bottom - 3 ) );
	DrawLine( Point( 4, cFillRect.bottom ), Point( GetBounds().right - 4, cFillRect.bottom ) );
}

Point ToolboxButton :: GetPreferredSize( bool bLargest ) const
{
	if( bLargest )
		return Point( COORD_MAX, COORD_MAX );

	return Point( 150, 70 );
}

