// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "tool_arc_state_0.h"
#include "common.h"
#include "windialogs/windia_alert.h"

using namespace os;

///////////////////////////////////////////////////////////////////////////////
//
// P R I V A T E
//
///////////////////////////////////////////////////////////////////////////////

class ArcState0 :: _Private
{
public:
	_Private(){};

	void _Layout( Rect cFrame )
	{
		m_Table->SetFrame( Rect( 0, 0, cFrame.Width(), cFrame.Height() ) );
	}

	enum ArcState0Message { MSG_CLOSE, MSG_POINT, MSG_CANCEL, MSG_CONTINUE, MSG_CENTER };
	
	ToolboxPoint* m_StartPoint;
	ToolboxAction* m_Action;

	TableView* m_Table;
};

///////////////////////////////////////////////////////////////////////////////
//
// T H E   C L A S S
//
///////////////////////////////////////////////////////////////////////////////
ArcState0 :: ArcState0( ToolArc* theTool, ToolboxSideBar* toolbox ) : State( theTool ), Toolbox( toolbox )
{
	// Create the private class
	m = new _Private();

	// Create the table
	m->m_Table = new TableView( Rect(), "", 1, 2, false );
	m->m_Table->SetRowSpacings( 4 );
	AddChild( m->m_Table );

	// Create buttons and attach them to table
	m->m_StartPoint = new ToolboxPoint( Rect(), "First point", "X: ", "Y: ", new Message( _Private::MSG_POINT ) );
	m->m_Table->Attach( m->m_StartPoint, 0, 1, 0, 1, ( TABLE_EXPAND | TABLE_FILL ), 0 );

	m->m_Action = new ToolboxAction( Rect(), "" );
	m->m_Table->Attach( m->m_Action, 0, 1, 1, 2, ( TABLE_EXPAND | TABLE_FILL ), ( TABLE_EXPAND | TABLE_FILL ) );

	// Add action items
	m->m_Action->AddButton( "Cancel", (Image*) LoadImage( "cancel.png" ), new Message( _Private::MSG_CANCEL ) , "Cancel the tool and return to main toolbox " );
	m->m_Action->AddButton( "Continue", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_CONTINUE ) , "Continue from the last point " );
	m->m_Action->AddButton( "Center", (Image*) LoadImage( "circle.png" ), new Message( _Private::MSG_CENTER ) , "Specify the center point " );

	State::SetToolbox( this );
}

ArcState0 :: ~ArcState0()
{	
	delete m;
}

void ArcState0 :: GotFocus( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_StartPoint->SetValue( coord );
}

void ArcState0 :: LostFocus( Canvas* canvas, Document* doc, Point coord )
{
	m->m_StartPoint->ClearValue();
}

void ArcState0 :: MouseMove( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	m->m_StartPoint->SetValue( coord );
}

String ArcState0 :: GetStatusText()
{
	return String( "Select first point of the arc" );
}

void ArcState0 :: PointSelected( Canvas* canvas, Document* doc, Point coord )
{
	coord = doc->MakeSnap( coord );
	GetTool()->SetProperty( "first_point", coord );
	GetTool()->SetState( 1 );
}

void ArcState0 :: SetFrame( const Rect& cRect, bool bNotifyServer )
{
	Toolbox::SetFrame( cRect, bNotifyServer );
	m->_Layout( cRect );
}

void ArcState0 :: AllAttached( void )
{
	Toolbox::AllAttached();

	m->m_StartPoint->SetTarget( this );
	m->m_Action->SetTarget( this );
}

void ArcState0 :: HandleMessage( Canvas* canvas, Document* doc, Message* pcMessage )
{
	switch( pcMessage->GetCode() )
	{
		case _Private::MSG_CANCEL:
			SetMainToolbox();
			break;
		case _Private::MSG_CONTINUE:
		{
			Point p;
			double tangent;

			canvas->Undraw();
		
			if( doc->GetContinuePoint( p, tangent ) )
			{
				GetTool()->SetState( 15 );
			}
			else
			{
				WinDiaAlert::ShowErrorAlert( "Arc continue", "It is not possible to continue.\nYou need to have drawn at least one line or arc." );
			}
			break;
		}
		case _Private::MSG_CENTER:
		{
			GetTool()->SetState( 3 );
			break;
		}
		case _Private::MSG_POINT:
			{
				Point p;

				if( pcMessage->FindPoint( "value", &p ) == EOK )
					PointSelected( canvas, doc, p );
		
				break;
			}
	}
}

