// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __TOOL_ARC_H__
#define __TOOL_ARC_H__

#include <gui/point.h>
#include <util/string.h>

#include "tool.h"
#include "state.h"
#include "document.h"

/* Description of the state
 * 0 - Center/<Start point>
 * 1 - Center/End/<Second point>
 * 2 - <End point>
 * 3 - <Center>
 * 4 - <Start point>
 * 5 - Angle/Length/<End point>
 * 6 - <Included angle>
 * 7 - <Length of coord>
 * 8 - <End point>
 * 9 - Angle/Direction/Radius/<Center>
 * 10 - <Direction from start point>
 * 11 - <Radius>
 * 12 - <Center>
 * 13 - Angle/Length/<End point>
 * 14 - <Included angle>
 * 15 - Continue
 */

class ToolArc : public Tool
{
public:
	ToolArc( ToolboxSideBar* parent );
	~ToolArc();
	
	void SetContinueArc( Document* doc, os::Point center, double radius, double start_angle, double end_angle );

	os::String Name() { return os::String( "Arc" ); };
	os::String Image() { return os::String( "circle.png" ); };
	os::String Description() { return os::String( "Draws an arc " ); };

private:
};

#endif
