// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __STYLE_H_
#define __STYLE_H_

#include <stdio.h>
#include <util/string.h>
#include <vector>

class Layer;
class Pattern;

class Style
{
public:
	enum StyleType { BY_LAYER, BY_BLOCK, BY_USER };

	Style();
	~Style() {};

	void SetLayer( Layer* layer ) { m_Layer = layer; };
	Layer* GetLayer() { return m_Layer; };

	void SetLineWidthType( enum StyleType linetype )  { m_LineWidthType = linetype; };
	enum StyleType GetLineWidthType()  { return m_LineWidthType; };
	double GetLineWidth();
	void SetLineWidth( double width ) { m_LineWidth = width; };

	void SetColourType( enum StyleType colourtype ) { m_ColourType = colourtype; };
	enum StyleType GetColourType()  { return m_ColourType; };
	void GetColour( double& r, double& b, double& g );
	void SetColour( double r, double g, double b ) { m_R = r; m_G = g; m_B = b; };

	void SetPatternType( enum StyleType type )  { m_PatternType = type; };
	enum StyleType GetPatternType()  { return m_PatternType; };
	Pattern* GetPattern();
	void SetPattern( Pattern* pattern ) { m_Pattern = pattern; };
	void SetPattern( os::String name ) { m_Pattern = NULL; m_PatternName = name; };

	void SetStyle( int start, std::vector< os::String >& split );

	os::String SaveAttributes();

private:
	Layer* m_Layer;

	enum StyleType m_LineWidthType;
	double m_LineWidth;

	enum StyleType m_ColourType;
	double m_R, m_B, m_G;	

	enum StyleType m_PatternType;
	os::String m_PatternName;
	Pattern* m_Pattern;
};

#endif

