// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "sidebar.h"
#include "messages.h"
#include "common.h"

using namespace os;

SideBar :: SideBar( const Rect& cFrame, const String& cTitle, uint32 nResizeMask, uint32 nFlags ) : View( cFrame, cTitle, nResizeMask, nFlags )
{
	BitmapImage* close_icon = LoadImage( "close_button.png" );
	m_CloseButton = new ImageButton( Rect(), "close_button", "", new Message( MSG_SIDEBAR_HIDE ), close_icon );
	m_CloseButton->SetTarget( GetWindow() );
	AddChild( m_CloseButton );
	Layout();
}

SideBar :: ~SideBar()
{
}

void SideBar :: SetFrame( const os::Rect& cRect, bool bNotifyServer )
{
	View::SetFrame( cRect, bNotifyServer );

	Layout();
}

Rect SideBar :: GetFrame() const
{
	Rect r = View::GetFrame();

	r.top += 25.0f;
	r.bottom -= 4.0f;
	r.left += 4.0f;
	r.right -= 4.0f;

	return r;
}

void SideBar :: Paint( const Rect& cUpdateRect )
{
	// Erase background noise
	FillRect( cUpdateRect, get_default_color( COL_NORMAL ) );

	// Draw fram around box
	DrawFrame( GetBounds(), FRAME_THIN );


	// Get title from child
	View* child = GetChildAt( 0 );
	String title = "Error";
	if( child != NULL )
		title = child->GetTitle();

	// Draw nice title
	SetFgColor( get_default_color( COL_MENU_TEXT ) );
	Point text_size = GetTextExtent( title );
	DrawString( Point( 12.0f, text_size.y), title );

	// Draw close button

	Rect cButtonFrame;
	cButtonFrame.left = GetBounds().right - text_size.y - 4.0f;
	cButtonFrame.right = GetBounds().right - 4.0f;
	cButtonFrame.top = 4.0f;
	cButtonFrame.bottom = text_size.y + 4.0f;
	

	// Draw same nice lines
	DrawFrame( Rect( 4.0f, 2.0f + text_size.y / 2.0f, 8.0f, 3.0f + text_size.y / 2.0f ), FRAME_THIN );
	DrawFrame( Rect( 4.0f, 6.0f + text_size.y / 2.0f, 8.0f, 7.0f + text_size.y / 2.0f ), FRAME_THIN );
	DrawFrame( Rect( 18.0f + text_size.x, 2.0f + text_size.y / 2.0f, cButtonFrame.left - 8.0f, 3.0f + text_size.y / 2.0f ), FRAME_THIN );
	DrawFrame( Rect( 18.0f + text_size.x, 6.0f + text_size.y / 2.0f, cButtonFrame.left - 8.0f, 7.0f + text_size.y / 2.0f ), FRAME_THIN );
}

Point SideBar :: GetPreferredSize( bool bLargest ) const
{
	return Point( 100.0f, 100.0f );
}

void SideBar :: Layout()
{
	Rect r( GetBounds().right - 14.0f - 6.0f, 4.0f, GetBounds().right - 6.0f, 4.0f + 14.0f );
	m_CloseButton->SetFrame( r );
}

