// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __OBJECT_ARC_H_
#define __OBJECT_ARC_H_

#include <vector>

#include <gui/point.h>

#include "object.h"

class Document;

class ObjectArc : public Object
{
public:
	ObjectArc( os::Point center, double radius, double start_angle, double stop_angle );
	~ObjectArc();

	void Erase( Canvas* canvas );
	void Draw( Canvas* canvas, bool save_background = false, bool update_server = true );
	void Draw( Canvas* canvas, Transform& transform, bool save_background = false, bool update_server = true );

	void DoTransform( Transform& transform );

	os::Rect GetBounds();
	bool HitCheck( os::Point coord, double sens );

	Object* Duplicate();

	bool SetProperty( int which, os::Variant& value );
	bool GetProperty( int which, os::Variant& value );

	bool GetSnapPoint( int type, os::Point p, std::vector< os::Point >& list );

	os::String Save();
	static bool Load( Document* doc, Layer* current_layer, std::vector< os::String >& split, bool old_ocadis = false );
private:
	void _Calc3P( os::Point& p1, os::Point& p2 );

	os::Point m_Center;
	double m_Radius;
	double m_StartAngle;
	double m_EndAngle;

};

#endif
