// oCADis (C)opyright 2007 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __DIALOG_OSNAP_H__
#define __DIALOG_OSNAP_H__

#include <gui/listview.h>
#include <gui/stringview.h>
#include <gui/button.h>
#include <gui/slider.h>

#include "dialogs/dialog.h"
#include "tableview.h"
#include "toolbox_frame.h"
#include "document.h"

class Document;

class DialogOSnap : public Dialog
{
public:
	DialogOSnap( DialogSideBar* parent );
	~DialogOSnap();

	virtual void SetFrame( const os::Rect& cRect, bool bNotifyServer = true );
	virtual void HandleMessage( Canvas* canvas, Document* doc, os::Message* pcMessage );
	void AllAttached( void );

	void Init( Document* doc );

private:
	void _UpdateDocument( Document* doc );
	void _HighlightRow( int mode );

	enum LayerMessage { MSG_SELECT, MSG_SELECT_ALL, MSG_DESELECT_ALL, MSG_SLIDER_DISTANCE, MSG_SLIDER_SENSITIVITY };

	void _Layout();

	os::TableView* m_theTable;
	os::ListView* m_OSnapList;

	// Settings
	ToolboxFrame* m_SettingsFrame;
	os::TableView* m_SettingsTable;
	os::StringView* m_SettingsLabel1;
	os::Slider* m_SettingsDistance;
	os::StringView* m_SettingsLabel2;
	os::Slider* m_SettingsSensitivity;

	// Button
	os::Button* m_SelectAll;
	os::Button* m_DeselectAll;



};

#endif
