// oCADis (C)opyright 2006 Jonas Jarvoll
//
// This is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __CADMATH_H__
#define __CADMATH_H__

#include <util/string.h>
#include <gui/point.h>
#include <gui/rect.h>

namespace CadMath
{
	#define FloatEllipson 0.0000001f

	void CalcAngleForArc3P( double& sa, double ma, double& ea);
	bool CalcArc3P( os::Point p1, os::Point p2, os::Point p3, os::Point& center, double& radius, double& start_angle, double& end_angle );
	void CalcArc2P( double ta, os::Point p1, os::Point& p2, os::Point p3, os::Point& center, double& radius, double& start_angle, double& end_angle);
	bool CalcArcCSE( os::Point center1, os::Point start_point, os::Point end_point, os::Point& center, double& radius, double& start_angle, double& end_angle);
	bool CalcArcCSA( os::Point center1, os::Point start_point, double angle, os::Point& center, double& radius, double& start_angle, double& end_angle);
	bool CalcArcCSL( os::Point center1, os::Point start_point, double length, os::Point& center, double& radius, double& start_angle, double& end_angle);

	double Distance( os::Point p1, os::Point p2 );
	double GetAngle( os::Point p1, os::Point p2 );

	bool BetweenAngles( double sa, double ea, double angle );

	double max( double v1, double v2 );
	double min( double v1, double v2 );

	os::Rect SortRect( os::Point p1, os::Point p2 );

	double Strtod( os::String string );

	void FixAngle( double& angle );

	double ConvertUserAngleToRadian( double value );
	double ConvertRadianToUserAngle( double value );

	float ConvertDeg2Rad( float value );
	float ConvertRad2Deg( float value );

	os::Point RotatePoint( double angle, os::Point origo, os::Point point );
}

#endif

