#! /bin/sh

# This is the initialisation script for Syllable Desktop.
# 
# ************************************************************************** #
#                            DO NOT EDIT THIS FILE!                          #
# ************************************************************************** #
#
# start.sh is called directly by the init process; do not call this file
# yourself.
# This script in turn calls /etc/profile, user-setup.sh, network-start.sh and
# user-start.sh  If you wish to modify your configuration or initialisation
# process you should edit these files instead.

# Log local kernel output into /var/log/kernel
/system/programs/dbterm 8 >> /var/log/kernel &

# Add a few additional symlinks which simplify navigation around the filesystem
ln -s boot/applications/ /
ln -s boot/documentation/ /

# Configure basic environment.
# BASh runs this, too, but do it earlier for the benefit of processes started here.
source /etc/profile

# Silently empty the temporary directory
if [ "$TEMP" != '' ]
then
	rm -r $TEMP/* > /dev/null 2>&1
fi

# If the graphical login isn't available, failsafe to a standalone server and
# abort further initialisation
if [ ! -e /system/programs/dlogin ]
then
	aterm &
	exit 1
fi

# Start the graphical login and servers
/system/programs/dlogin < /dev/null >> /var/log/desktop 2>&1 &

# No more environment variables can be defined for the user's environment
# after DLogin has started

/system/mediaserver > /dev/null &
/system/registrar > /dev/null &

# Check for network changes & configure the network if required
/applications/preferences/Network --detect

source /system/network-start.sh

# inetd is a special case and is always started first if INetUtils is installed

if [ -e /resources/index/framework/executables/inetd ]
then
	/resources/index/framework/executables/inetd &
fi

# Packages that require initalisation can include tasks/setup/ and tasks/start/
# subdirectories, which should contain the init script(s). E.g. Apache would have
# start/apache which would call apachectl, OpenSSH would have start/sshd which would
# start sshd, etc. The package manager will collect all of these scripts together in
# /resources/index/tasks/setup/ and /resources/index/tasks/start/; all we need to
# do is run each script in turn.

# Run the late init scripts

for start in `ls /system/index/tasks/start/`
do
	source /system/index/tasks/start/$start
done

for start in `ls /resources/index/tasks/start/`
do
	source /resources/index/tasks/start/$start
done

# Do user initialisation
source /system/user-start.sh
